/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CQueue.h,v 1.3 1999/09/23 23:50:54 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CQueue_h	// [
#define Included_CQueue_h

#include "pgpClassesConfig.h"
#include "CList.h"

_PGP_BEGIN

// Class CQueue

template <typename T> class CQueue
{
	NOT_COPYABLE(CQueue)

public:
	CQueue() { }
	~CQueue() { }

	PGPUInt32	Size() const {return mList.Count();}

	void	Enqueue(T *pItem);
	T *		Dequeue();

	void	Empty() {mList.Empty();}
	void	EmptyWithDelete() {mList.EmptyWithDelete();}

private:
	CList<T>	mList;
};

// Class CQueue template member functions.

template <typename T>
void 
CQueue<T>::Enqueue(T *pItem)
{
	mList.AddTail(pItem);
}

template <typename T >
T * 
CQueue<T>::Dequeue()
{
	if (Size() == 0)
		return NULL;
	else
		return mList.Remove(mList.Head());
}

_PGP_END

#endif	// ] Included_CQueue_h
